package gov.va.med.mhv.vitals.validator;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.dto.PulseOximetryReadingDTO;
import gov.va.med.mhv.vitals.enums.OxygenDeviceEnumeraion;
import gov.va.med.mhv.vitals.enums.SymptomsEnumeration;
import gov.va.med.mhv.vitals.util.MessagesUtil;

@Component
public class PulseOximetryValidaor  extends Validator {
	
	public static final int COMMENTS_MAX_LENGTH = 255;
	private static final Integer OXYGENSETTING_MIN_VALUE = new Integer("1");
	private static final Integer OXYGENSETTING_MAX_VALUE = new Integer("15");
	private static final Integer RESPIRATORYRATE_MIN_VALUE = new Integer("0");
	private static final Integer RESPIRATORYRATE_MAX_VALUE = new Integer("99");
	private static final Integer READING_MIN_VALUE = new Integer("50");
	private static final Integer READING_MAX_VALUE = new Integer("100");

	
	@Autowired
	private MessagesUtil messages;
	
	public void pulseOXimetryValidations(ResponseUtil response, PulseOximetryReadingDTO podto) {
		fieldValidation(response, podto);
	}

	private void fieldValidation(ResponseUtil response,	PulseOximetryReadingDTO podto) {
		validateComments(response,podto);
		validateSuppOxygenDevice(response,podto);
		validateOxygenSetting(response,podto);
		validateRespiratoryRate(response,podto);
		validateReading(response,podto);
		validateDateEntered(response,podto);
		validateOtherSymptoms(response,podto);
		validateSymptoms(response,podto);
	}

	private void validateSymptoms(ResponseUtil response,PulseOximetryReadingDTO podto) {
		String value = podto.getSymptoms();
		if ( value == null ) {
			Validations.validateRequired("symptoms", value, response.getValidationErrors());
			return;
		}	
		Validations.validateEnumeration("symptoms", value, SymptomsEnumeration.values(), response.getValidationErrors());
		
	}

	private void validateOtherSymptoms(ResponseUtil response,PulseOximetryReadingDTO podto) {
		String value = podto.getOtherSymptoms();
		if ( value == null ) {
			return;
		}						
	}

	private void validateDateEntered(ResponseUtil response,	PulseOximetryReadingDTO podto) {
		Date value = podto.getReading();
		if( value == null ) {
			Validations.validateRequired("readingDate", value, response.getValidationErrors());
			return;
		}

		
	}

	private void validateReading(ResponseUtil response,	PulseOximetryReadingDTO podto) {
		Integer value = podto.getOximeterReading();
		
		if( value == null ) {
			Validations.validateRequired("Oximeter Reading", value, response.getValidationErrors());
			return;
		}		
		Validations.validateMinValue("Oximeter Reading minumum", value, READING_MIN_VALUE,"The Oximeter Reading ", response.getValidationErrors());
		Validations.validateMaxValue("Oximeter Reading maximum",value, READING_MAX_VALUE,"The Oximeter Reading ", response.getValidationErrors());
	}

	private void validateRespiratoryRate(ResponseUtil response,	PulseOximetryReadingDTO podto) {
		Integer value = podto.getRespiratoryRate();
		
		if( value == null ) {
			Validations.validateRequired("respiratoryRate", value, response.getValidationErrors());
			return;
		}		
		Validations.validateMinValue("respiratoryRate minumum", value, RESPIRATORYRATE_MIN_VALUE,"The respiratoryRate ", response.getValidationErrors());
		Validations.validateMaxValue("respiratoryRate maximum",value, RESPIRATORYRATE_MAX_VALUE,"The respiratoryRate ", response.getValidationErrors());
	}

	private void validateOxygenSetting(ResponseUtil response,PulseOximetryReadingDTO podto) {
		Integer value = podto.getOxygenSetting();
		
		if( value == null ) {
			return;
		}		
		Validations.validateMinValue("oxygenSetting minumum", value, OXYGENSETTING_MIN_VALUE,"The Oxygen Setting ", response.getValidationErrors());
		Validations.validateMaxValue("oxygenSetting maximum",value, OXYGENSETTING_MAX_VALUE,"The Oxygen Setting ", response.getValidationErrors());
	}

	private void validateSuppOxygenDevice(ResponseUtil response,PulseOximetryReadingDTO podto) {
		String value = podto.getSuppOxygenDevice();
		
		if ( value == null ) {
			Validations.validateRequired("suppOxygenDevice", value, response.getValidationErrors());
			return;
		}	
		Validations.validateEnumeration("suppOxygenDevice", value, OxygenDeviceEnumeraion.values(), response.getValidationErrors());
		
	}

	private void validateComments(ResponseUtil response,PulseOximetryReadingDTO podto) {
		String value = podto.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("comments",value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
		
	}


}
